/***************************************************************************
 *   Copyright (C) 2008 by Tim McCormick   *
 *   tim@pcbsd.org   *
 *                                                                         *
 *   Permission is hereby granted, free of charge, to any person obtaining *
 *   a copy of this software and associated documentation files (the       *
 *   "Software"), to deal in the Software without restriction, including   *
 *   without limitation the rights to use, copy, modify, merge, publish,   *
 *   distribute, sublicense, and/or sell copies of the Software, and to    *
 *   permit persons to whom the Software is furnished to do so, subject to *
 *   the following conditions:                                             *
 *                                                                         *
 *   The above copyright notice and this permission notice shall be        *
 *   included in all copies or substantial portions of the Software.       *
 *                                                                         *
 *   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,       *
 *   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF    *
 *   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. *
 *   IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR     *
 *   OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, *
 *   ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR *
 *   OTHER DEALINGS IN THE SOFTWARE.                                       *
 ***************************************************************************/
#include <QCoreApplication>
#include <QDebug>
#include <QDialog>
#include <QFile>
#include <QLabel>
#include <QPushButton>
#include <QProcess>
#include <QProgressDialog>
#include <QMenu>
#include <QMessageBox>
#include <QTranslator>
#include <QTreeWidget>
#include <QWidget>

 
#ifndef _PCBSD_UTILS_H_
#define _PCBSD_UTILS_H_

namespace pcbsd
{

class Utils
{
public:

   static bool setConfFileValue( QString oFile, QString oldKey, QString newKey );
   static bool setConfFileValue( QString oFile, QString oldKey, QString newKey, int occur );
   static QString getConfFileValue( QString oFile, QString Key );
   static QString getConfFileValue( QString oFile, QString Key, int occur );
   static QString getConfFileValue( QString oFile, QString Key, QString ValRx, int occur );
   static QStringList runShellCommand( QString command );
   static QStringList runShellCommand( QString command , bool &success);

};

} //namespace

#endif
