#!/bin/sh

FILES="plasma-org.kde.plasma.desktop-appletsrc plasmarc plasmashellrc"
backup_count="100"
backup_count="`expr -e 0${backup_count} + 1`"

USER="`/usr/bin/whoami`"
DIR="`/usr/sbin/pw user show ${USER} | /usr/bin/cut -d ':' -f9`/.config"

if [ -d $DIR ]; then

    for FILENAME in ${FILES}
    do
        if [ -f ${DIR}/${FILENAME} ]; then
            TARFILES="${TARFILES} ${DIR}/${FILENAME}"
        fi
    done

    /usr/bin/tar cPfz ${DIR}/plasma_backup_`/bin/date +'%Y%m%d_%H%M%S'`.tgz ${TARFILES}
    /bin/ls -1t ${DIR}/plasma_backup_* | /usr/bin/tail -n+${backup_count} | /usr/bin/xargs /bin/rm -f

fi
